def recherche(elt : int, tab : list) -> list:
    """ renvoie le tableau des indices de elt dans tab si elt est dans tab
    et le tableau vide [] sinon."""
    idx = []
    for i in range(len(tab)):
        if tab[i] == elt:
            idx.append(i)
    return idx

assert recherche(3, [3, 2, 1, 3, 2, 1]) == [0, 3]
assert recherche(4, [1, 2, 3]) == []
assert recherche(4, []) == []

def moyenne(nom : str, resultats : dict) -> float:
    """ renvoie la moyenne arrondie au dixième."""
    if nom in resultats:
        notes = resultats[nom]
        total_points = 0
        total_coefficients = 0
        for valeurs in notes.values():
            note, coefficient   = valeurs
            total_points       += note * coefficient
            total_coefficients += coefficient
        # toujours vérifier une division par 0 !!
        return round(total_points / total_coefficients, 1)
    else:
        return -1

resultats = {'Dupont':{'DS1' : [15.5, 4],
                       'DM1' : [14.5, 1],
                       'DS2' : [13, 4],
                       'PROJET1' : [16, 3],
                       'DS3' : [14, 4]},
             'Dupond':{'DS1' : [1, 4]},
             'Durand':{'DS1' : [6, 4],
                       'DM1' : [14.5, 1],
                       'DS2' : [8, 4],
                       'PROJET1' : [9, 3],
                       'IE1' : [7, 2],
                       'DS3' : [8, 4],
                       'DS4' :[15, 4]},
             'Durant':{'DS1' : [1, 4],
                       'DS2' : [6, 1]}}

assert moyenne('toto', resultats) == -1
assert moyenne('Dupont', resultats) == 14.5
assert moyenne('Dupond', resultats) == 1
assert moyenne('Durand', resultats) == 9.2
assert moyenne('Durant', resultats) == 2
