def conv_bin(n : int) -> tuple:
    """renvoie un couple (b,bit) où :
     b est une liste d'entiers correspondant à la représentation binaire de n;
     bit correspond aux nombre de bits qui constituent b."""
    if n < 0:
        return None

    nb_bit = 1
    bin    = [n % 2]

    n = n // 2
    while n:
        nb_bit += 1
        bin = [n % 2] + bin
        n = n // 2
    return (bin, nb_bit)

assert conv_bin(-1) == None
assert conv_bin(0) == ([0], 1)
assert conv_bin(9) == ([1,0,0,1], 4)
assert conv_bin(14) == ([1,1,1,0], 4)

def tri_bulles(T : list) -> list:
    n = len(T)
    for i in range(n-1, 0, -1):
        for j in range(i):
            if T[j] > T[j+1]:
                temp = T[j]
                T[j] = T[j+1]
                T[j+1] = temp
    return T

assert tri_bulles([0, 1, 6, 5, 4, 3]) == [0, 1, 3, 4, 5, 6]
assert tri_bulles([0, 1, 2]) == [0, 1, 2]
assert tri_bulles([2, 1, 0]) == [0, 1, 2]
assert tri_bulles([0]) == [0]
assert tri_bulles([]) == []
