def moyenne(couple : list) -> float:
    """ renvoie la moyenne pondérée d'une liste donnée"""
    total, nb_coeff = 0, 0
    for note, coeff in couple:
        total    += note * coeff
        nb_coeff += coeff
    return total / nb_coeff if nb_coeff else None

assert moyenne([]) == None  # pas de note
assert moyenne([(0,2)]) == 0
assert moyenne([(15,2)]) == 15
assert moyenne([(15,2), (9,1), (12,3)]) == 12.5

def pascal(n : int) -> list:
    C= [[1]]    # traiter n < 1 !!
    for k in range(1, n):
        Ck = [1]
        for i in range(1, k):
            Ck.append(C[k-1][i-1]+C[k-1][i] )
        Ck.append(1)
        C.append(Ck)
    return C

assert pascal(1) == [[1]]
assert pascal(2) == [[1], [1, 1]]
assert pascal(3) == [[1], [1, 1], [1, 2, 1]]
assert pascal(4) == [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1]]
assert pascal(5) == [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1], [1, 4, 6, 4, 1]]
assert pascal(6) == [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1], [1, 4, 6, 4, 1], [1, 5, 10, 10, 5, 1]]
