def fibonnaci_dynamique_desc(n : int) -> int:
    """ calcul de la suite de fibonacci de façon dynamique descendante """
    if type(n) is not int or n < 0:
        return None

    def fibonacci(n : int, table : list) -> int:
        if table[n] == None:
            if n < 2:
                table[n] = n
            else:
                table[n] = fibonacci(n-1, table) + fibonacci(n-2, table)
        return table[n]

    table = [None]*(n+1)
    return fibonacci(n, table)

def fibonnaci_dynamique_asc(n : int) -> int:
    """ calcul de la suite de fibonacci de façon dynamique ascendante """
    if type(n) is not int or n < 0:
        return None

    f = [0,1]
    for i in range(1, n):
        f.append(f[i] + f[i-1])
    return f[n]

assert fibonnaci_dynamique_desc(1) == 1
assert fibonnaci_dynamique_desc(2) == 1
assert fibonnaci_dynamique_desc(25) == 75025
assert fibonnaci_dynamique_desc(45) == 1134903170

assert fibonnaci_dynamique_asc(1) == 1
assert fibonnaci_dynamique_asc(2) == 1
assert fibonnaci_dynamique_asc(25) == 75025
assert fibonnaci_dynamique_asc(45) == 1134903170

def meilleures_notes(liste_eleves : list, liste_notes : list) -> tuple:
    note_maxi = 0
    nb_eleves_note_maxi = 0
    liste_maxi = []

    for compteur in range(len(liste_notes)):
        if liste_notes[compteur] == note_maxi:
            nb_eleves_note_maxi = nb_eleves_note_maxi + 1
            liste_maxi.append(liste_eleves[compteur])
        if liste_notes[compteur] > note_maxi:
            note_maxi = liste_notes[compteur]
            nb_eleves_note_maxi = 1
            liste_maxi = [liste_eleves[compteur]]

    return (note_maxi, nb_eleves_note_maxi, liste_maxi)

liste_eleves = ['a','b','c','d','e','f','g','h','i','j']
liste_notes = [1, 40, 80, 60, 58, 80, 75, 80, 60, 24]

assert meilleures_notes(liste_eleves, liste_notes) == (80, 3, ['c', 'f', 'h'])