def rendu(somme_a_rendre : int) ->list:
    """ renvoie une liste de trois entiers n1, n2 et n3 qui
    correspondent aux nombres de billets de 5 euros (n1) de pièces de 2 euros (n2) et de
    pièces de 1 euro (n3) à rendre afin que le total rendu soit égal à somme_a_rendre.
    """
    n = [0, 0, 0]
    i = 0

    billets = [5,2,1]
    for b in billets:
        while somme_a_rendre >= b:  # attention si somme_a_rendre < 0
            somme_a_rendre -= b
            n[i] += 1
        i += 1
    return n

assert rendu(0) == [0,0,0]
assert rendu(3) == [0,1,1]
assert rendu(13) == [2,1,1]
assert rendu(64) == [12,2,0]
assert rendu(89) == [17,2,0]
assert rendu(88) == [17,1,1]

class Maillon :
    def __init__(self, v) :
        self.valeur  = v
        self.suivant = None

class File :
    def __init__(self) :
        self.dernier_file = None

    def enfile(self, element) :
        nouveau_maillon = Maillon(element)
        if self.dernier_file != None:
            nouveau_maillon.suivant = self.dernier_file
        self.dernier_file = nouveau_maillon

    def est_vide(self) :
        return self.dernier_file == None

    def affiche(self) :
        file = []
        maillon = self.dernier_file
        while maillon != None :
            file.append(maillon.valeur)
            maillon = maillon.suivant
        return file

    def defile(self) :
        if not self.est_vide() :
            if self.dernier_file.suivant == None :
                resultat = self.dernier_file.valeur
                self.dernier_file = None
                return resultat
            maillon = self.dernier_file
            while maillon.suivant.suivant != None :
                maillon = maillon.suivant
            resultat = maillon.suivant.valeur
            maillon.suivant = None
            return resultat
        return None

F = File()
assert F.est_vide() == True
F.enfile(2)
assert F.affiche() == [2]
assert F.est_vide() == False
F.enfile(5)
F.enfile(7)
assert F.affiche() == [7, 5, 2]
assert F.defile() == 2
assert F.defile() == 5
assert F.affiche() == [7]
assert F.defile() == 7
assert F.defile() == None
assert F.affiche() == []
