from math import sqrt   # import de la fonction racine carrée

def recherche(tab : list, n : int) -> int:
    """ renvoie l'indice de la dernière occurrence d'un élémént
    dans un tableau non vide d'entiers et un entier.
    Si l'élément n'est pas présent, la fonction renvoie la longueur du tableau."""
    for i in range(len(tab)-1, -1, -1):
        if tab[i] == n:
            return i
    return len(tab)

assert recherche([5, 3], 1) == 2
assert recherche([2, 4], 2) == 0
assert recherche([2, 3, 5, 2, 4], 2) == 3
assert recherche([], 2) == 0

def distance(point1 : tuple, point2 : tuple ) -> float:
    """ Calcule et renvoie la distance entre deux points. """
    return sqrt((point1[0] - point2[0])**2 + (point1[1] - point2[1])**2)

assert distance((0, 0), (0, 0)) == 0
assert distance((0, 0), (1, 1)) == sqrt(2)
assert distance((0, 0), (1, -1)) == sqrt(2)
assert distance((1, 0), (5, 3)) == 5.0, "erreur de calcul"

def plus_courte_distance(tab : list, depart : tuple) -> tuple:
    """ Renvoie le point du tableau tab se trouvant à la plus
    courte distance du point depart."""
    point    = tab[0]   # attention si tableau vide !!
    min_dist = distance(point, depart)
    for i in range (1, len(tab)):
        if distance(tab[i], depart) < min_dist:
            point    = tab[i]
            min_dist = distance(point, depart)
    return point

assert plus_courte_distance([(7, 9), (2, 5), (5, 2)], (0, 0)) == (2, 5)
assert plus_courte_distance([(7, 9), (2, 5), (5, 2), (-1, -1)], (0, 0)) == (-1, -1)
